<?xml version="1.0" ?>
<template expand_clusters="true" version="2">
    <!-- Updated on 2025-11-13T18:03:25.948411744 using eu-gerrit-1.euhpc.arm.com:29418/dsg/streamline - origin/changes/83/830983/1 (128f11507b5b58b15280689d64925b5636464515) - "Split out top down timeline charts where there are different divisors" -->
    <supported-cpuid id="Cortex-X925" />
    <chart average_cores="yes" average_selection="yes" height="61" percentage="yes" rendering_type="bar" series_composition="stacked" title="CPU Activity">
        <series color="58,223,67" description="User activity" display="AVERAGE" expression="$CPUActivityUser" name="User activity"/>
        <series color="223,71,66" description="System activity" display="AVERAGE" expression="$CPUActivitySystem" name="System activity"/>
    </chart>   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instructions per Cycle (Cortex-X925)">
        <series color="255,153,0" description="This metric measures the number of instructions retired per cycle" expression="if(($InstructionsPerCycleCortexX925CPU_CYCLES &gt; 0), ($InstructionsPerCycleCortexX925INST_RETIRED / $InstructionsPerCycleCortexX925CPU_CYCLES), 0)" name="Instructions Per Cycle" units="instructions"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Cycle Accounting (Cortex-X925)">
        <series color="255,153,0" description="This metric is the percentage of cycles that were stalled due to resource constraints in the frontend unit of the processor" expression="if(($FrontendStalledCyclesCortexX925CPU_CYCLES &gt; 0), min(($FrontendStalledCyclesCortexX925STALL_FRONTEND / $FrontendStalledCyclesCortexX925CPU_CYCLES), 1), 0)" name="Frontend Stalled Cycles" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of cycles that were stalled due to resource constraints in the backend unit of the processor" expression="if(($BackendStalledCyclesCortexX925CPU_CYCLES &gt; 0), min(($BackendStalledCyclesCortexX925STALL_BACKEND / $BackendStalledCyclesCortexX925CPU_CYCLES), 1), 0)" name="Backend Stalled Cycles" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Level 1 (Cortex-X925)">
        <series color="255,153,0" description="This metric is the percentage of total slots that were stalled due to resource constraints in the frontend of the processor" expression="if(($FrontendBoundCortexX925CPU_CYCLES &gt; 0), min((($FrontendBoundCortexX925STALL_SLOT_FRONTEND / (10 * $FrontendBoundCortexX925CPU_CYCLES)) - ($FrontendBoundCortexX925STALL_FRONTEND_FLUSH / $FrontendBoundCortexX925CPU_CYCLES)), 1), 0)" name="Frontend Bound" units="percent"/>
        <series color="255,0,229" description="This metric is the percentage of total slots that were stalled due to resource constraints in the backend of the processor" expression="if(($BackendBoundCortexX925CPU_CYCLES &gt; 0), min(($BackendBoundCortexX925STALL_SLOT_BACKEND / (10 * $BackendBoundCortexX925CPU_CYCLES)), 1), 0)" name="Backend Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total slots that retired operations, which indicates cycles that were utilized efficiently" expression="if(($RetiringCortexX925CPU_CYCLES &gt; 0) &amp;&amp; ($RetiringCortexX925OP_SPEC &gt; 0), min(((1 - ($RetiringCortexX925STALL_SLOT / ($RetiringCortexX925CPU_CYCLES * 10))) * ($RetiringCortexX925OP_RETIRED / $RetiringCortexX925OP_SPEC)), 1), 0)" name="Retiring" units="percent"/>
        <series color="0,255,25" description="This metric is the percentage of total slots that executed operations and didn't retire due to a pipeline flush This indicates cycles that were utilized but inefficiently" expression="if(($BadSpeculationCortexX925CPU_CYCLES &gt; 0) &amp;&amp; ($BadSpeculationCortexX925OP_SPEC &gt; 0), min((((1 - ($BadSpeculationCortexX925STALL_SLOT / (10 * $BadSpeculationCortexX925CPU_CYCLES))) * (1 - ($BadSpeculationCortexX925OP_RETIRED / $BadSpeculationCortexX925OP_SPEC))) + ($BadSpeculationCortexX925STALL_FRONTEND_FLUSH / $BadSpeculationCortexX925CPU_CYCLES)), 1), 0)" name="Bad Speculation" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="General (Cortex-X925)">
        <series color="255,153,0" description="This metric measures the percentage of operations speculatively executed that are subsequently retired" expression="if(($RetiredOperationsPercentageCortexX925OP_SPEC &gt; 0), min(($RetiredOperationsPercentageCortexX925OP_RETIRED / $RetiredOperationsPercentageCortexX925OP_SPEC), 1), 0)" name="Retired Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Frontend (Frontend Bound) (Cortex-X925)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the frontend due to frontend core resource constraints not related to instruction fetch latency issues caused by memory access components" expression="if(($FrontendCoreBoundCortexX925STALL_FRONTEND &gt; 0), min(($FrontendCoreBoundCortexX925STALL_FRONTEND_CPUBOUND / $FrontendCoreBoundCortexX925STALL_FRONTEND), 1), 0)" name="Frontend Core Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the frontend due to frontend core resource constraints related to the instruction fetch latency issues caused by memory access components" expression="if(($FrontendMemoryBoundCortexX925STALL_FRONTEND &gt; 0), min(($FrontendMemoryBoundCortexX925STALL_FRONTEND_MEMBOUND / $FrontendMemoryBoundCortexX925STALL_FRONTEND), 1), 0)" name="Frontend Memory Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Frontend (Frontend Core Bound) (Cortex-X925)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the frontend as the processor is recovering from a pipeline flush caused by bad speculation or other machine resteers" expression="if(($FrontendCoreFlushBoundCortexX925STALL_FRONTEND_CPUBOUND &gt; 0), min(($FrontendCoreFlushBoundCortexX925STALL_FRONTEND_FLUSH / $FrontendCoreFlushBoundCortexX925STALL_FRONTEND_CPUBOUND), 1), 0)" name="Frontend Core Flush Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the frontend as the decode unit is awaiting input from the branch prediction unit" expression="if(($FrontendCoreFlowBoundCortexX925STALL_FRONTEND_CPUBOUND &gt; 0), min(($FrontendCoreFlowBoundCortexX925STALL_FRONTEND_FLOW / $FrontendCoreFlowBoundCortexX925STALL_FRONTEND_CPUBOUND), 1), 0)" name="Frontend Core Flow Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Frontend (Frontend Memory Bound) (Cortex-X925)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the frontend due to instruction fetch latency issues caused by instruction cache misses" expression="if(($FrontendMemCacheBoundCortexX925STALL_FRONTEND_MEMBOUND &gt; 0), min((($FrontendMemCacheBoundCortexX925STALL_FRONTEND_L1I + $FrontendMemCacheBoundCortexX925STALL_FRONTEND_MEM) / $FrontendMemCacheBoundCortexX925STALL_FRONTEND_MEMBOUND), 1), 0)" name="Frontend Mem Cache Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the frontend due to instruction fetch latency issues caused by instruction TLB misses" expression="if(($FrontendMemTLBBoundCortexX925STALL_FRONTEND_MEMBOUND &gt; 0), min(($FrontendMemTLBBoundCortexX925STALL_FRONTEND_TLB / $FrontendMemTLBBoundCortexX925STALL_FRONTEND_MEMBOUND), 1), 0)" name="Frontend Mem TLB Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Frontend (Frontend Mem Cache Bound) (Cortex-X925)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the frontend due to memory access latency issues caused by level 1 instruction cache misses" expression="if((($FrontendCacheL1IBoundCortexX925STALL_FRONTEND_L1I + $FrontendCacheL1IBoundCortexX925STALL_FRONTEND_MEM) &gt; 0), min(($FrontendCacheL1IBoundCortexX925STALL_FRONTEND_L1I / ($FrontendCacheL1IBoundCortexX925STALL_FRONTEND_L1I + $FrontendCacheL1IBoundCortexX925STALL_FRONTEND_MEM)), 1), 0)" name="Frontend Cache L1I Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the frontend due to memory access latency issues caused by level 2 instruction cache misses" expression="if((($FrontendCacheL2IBoundCortexX925STALL_FRONTEND_L1I + $FrontendCacheL2IBoundCortexX925STALL_FRONTEND_MEM) &gt; 0), min(($FrontendCacheL2IBoundCortexX925STALL_FRONTEND_MEM / ($FrontendCacheL2IBoundCortexX925STALL_FRONTEND_L1I + $FrontendCacheL2IBoundCortexX925STALL_FRONTEND_MEM)), 1), 0)" name="Frontend Cache L2I Bound" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Instruction Cache Effectiveness (Frontend Cache L1I Bound) (Cortex-X925)">
        <series color="255,153,0" description="This metric measures the number of level 1 instruction cache accesses missed per thousand instructions executed" expression="if(($L1ICacheMPKICortexX925INST_RETIRED &gt; 0), (($L1ICacheMPKICortexX925L1I_CACHE_REFILL / $L1ICacheMPKICortexX925INST_RETIRED) * 1000), 0)" name="L1I Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Instruction Cache Effectiveness (Frontend Cache L1I Bound) (Cortex-X925)">
        <series color="255,153,0" description="This metric measures the ratio of level 1 instruction cache accesses missed to the total number of level 1 instruction cache accesses. This gives an indication of the effectiveness of the level 1 instruction cache." expression="if(($L1ICacheMissPercentageCortexX925L1I_CACHE &gt; 0), min(($L1ICacheMissPercentageCortexX925L1I_CACHE_REFILL / $L1ICacheMissPercentageCortexX925L1I_CACHE), 1), 0)" name="L1I Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instruction TLB Effectiveness (Frontend Mem TLB Bound) (Cortex-X925)">
        <series color="255,153,0" description="This metric measures the number of instruction TLB Walks per thousand instructions executed" expression="if(($ITLBMPKICortexX925INST_RETIRED &gt; 0), (($ITLBMPKICortexX925ITLB_WALK / $ITLBMPKICortexX925INST_RETIRED) * 1000), 0)" name="ITLB MPKI" units="misses"/>
        <series color="0,102,255" description="This metric measures the number of level 1 instruction TLB accesses missed per thousand instructions executed" expression="if(($L1InstructionTLBMPKICortexX925INST_RETIRED &gt; 0), (($L1InstructionTLBMPKICortexX925L1I_TLB_REFILL / $L1InstructionTLBMPKICortexX925INST_RETIRED) * 1000), 0)" name="L1 Instruction TLB MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Instruction TLB Effectiveness (Frontend Mem TLB Bound) (Cortex-X925)">
        <series color="255,153,0" description="This metric measures the ratio of instruction TLB Walks to the total number of instruction TLB accesses. This gives an indication of the effectiveness of the instruction TLB accesses." expression="if(($ITLBWalkPercentageCortexX925L1I_TLB &gt; 0), min(($ITLBWalkPercentageCortexX925ITLB_WALK / $ITLBWalkPercentageCortexX925L1I_TLB), 1), 0)" name="ITLB Walk Percentage" units="percent"/>
        <series color="255,0,229" description="This metric measures the ratio of instruction TLB Walks that returned large page to the total number of instruction TLB accesses" expression="if(($ITLBWalkLargePagePercentageCortexX925L1I_TLB &gt; 0), min(($ITLBWalkLargePagePercentageCortexX925ITLB_WALK_LARGE / $ITLBWalkLargePagePercentageCortexX925L1I_TLB), 1), 0)" name="ITLB Walk Large Page Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of instruction TLB Walks that returned large page to the total number of instruction TLB accesses" expression="if(($ITLBWalkSmallPagePercentageCortexX925L1I_TLB &gt; 0), min(($ITLBWalkSmallPagePercentageCortexX925ITLB_WALK_SMALL / $ITLBWalkSmallPagePercentageCortexX925L1I_TLB), 1), 0)" name="ITLB Walk Small Page Percentage" units="percent"/>
        <series color="0,255,25" description="This metric measures the ratio of level 1 instruction TLB accesses missed to the total number of level 1 instruction TLB accesses. This gives an indication of the effectiveness of the level 1 instruction TLB." expression="if(($L1InstructionTLBMissPercentageCortexX925L1I_TLB &gt; 0), min(($L1InstructionTLBMissPercentageCortexX925L1I_TLB_REFILL / $L1InstructionTLBMissPercentageCortexX925L1I_TLB), 1), 0)" name="L1 Instruction TLB Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instruction TLB Effectiveness (Frontend Mem TLB Bound) (Cortex-X925)">
        <series color="255,153,0" description="This metric measures the average depth of the instruction TLB walks for an instruction TLB refill" expression="if(($ITLBWalkAverageDepthOfAccessesCortexX925ITLB_WALK &gt; 0), ($ITLBWalkAverageDepthOfAccessesCortexX925ITLB_STEP / $ITLBWalkAverageDepthOfAccessesCortexX925ITLB_WALK), 0)" name="ITLB Walk Average Depth of Accesses" units="accesses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instruction TLB Effectiveness (Frontend Mem TLB Bound) (Cortex-X925)">
        <series color="255,153,0" description="This metric measures the average latency of instruction TLB walks in CPU cycles" expression="if(($ITLBWalkAverageLatencyCortexX925ITLB_WALK &gt; 0), ($ITLBWalkAverageLatencyCortexX925ITLB_WALK_PERCYC / $ITLBWalkAverageLatencyCortexX925ITLB_WALK), 0)" name="ITLB Walk Average Latency" units="cycles"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Bound) (Cortex-X925)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the backend due to backend core resource constraints not related to instruction fetch latency issues caused by memory access components" expression="if(($BackendCoreBoundCortexX925STALL_BACKEND &gt; 0), min(($BackendCoreBoundCortexX925STALL_BACKEND_CPUBOUND / $BackendCoreBoundCortexX925STALL_BACKEND), 1), 0)" name="Backend Core Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the backend due to backend core resource constraints related to memory access latency issues caused by memory access components" expression="if(($BackendMemoryBoundCortexX925STALL_BACKEND &gt; 0), min(($BackendMemoryBoundCortexX925STALL_BACKEND_MEMBOUND / $BackendMemoryBoundCortexX925STALL_BACKEND), 1), 0)" name="Backend Memory Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Core Bound) (Cortex-X925)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the backend as the rename unit registers are unavailable" expression="if(($BackendCoreRenameBoundCortexX925STALL_BACKEND_CPUBOUND &gt; 0), min(($BackendCoreRenameBoundCortexX925STALL_BACKEND_RENAME / $BackendCoreRenameBoundCortexX925STALL_BACKEND_CPUBOUND), 1), 0)" name="Backend Core Rename Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Core Bound) (Cortex-X925)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the backend due to issue queues being full to accept operations for execution" expression="if(($BackendBusyBoundCortexX925STALL_BACKEND &gt; 0), min(($BackendBusyBoundCortexX925STALL_BACKEND_BUSY / $BackendBusyBoundCortexX925STALL_BACKEND), 1), 0)" name="Backend Busy Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Memory Bound) (Cortex-X925)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the backend due to memory latency issues caused by data cache misses" expression="if(($BackendMemoryCacheBoundCortexX925STALL_BACKEND_MEMBOUND &gt; 0), min((($BackendMemoryCacheBoundCortexX925STALL_BACKEND_L1D + $BackendMemoryCacheBoundCortexX925STALL_BACKEND_MEM) / $BackendMemoryCacheBoundCortexX925STALL_BACKEND_MEMBOUND), 1), 0)" name="Backend Memory Cache Bound" units="percent"/>
        <series color="153,0,255" description="This metric is the percentage of total cycles stalled in the backend due to memory access latency issues caused by data TLB misses" expression="if(($BackendMemoryTLBBoundCortexX925STALL_BACKEND_MEMBOUND &gt; 0), min(($BackendMemoryTLBBoundCortexX925STALL_BACKEND_TLB / $BackendMemoryTLBBoundCortexX925STALL_BACKEND_MEMBOUND), 1), 0)" name="Backend Memory TLB Bound" units="percent"/>
        <series color="0,255,153" description="This metric is the percentage of total cycles stalled in the frontend due to memory write pending caused by stores stalled in the pre-commit stage" expression="if(($BackendMemoryStoreBoundCortexX925STALL_BACKEND_MEMBOUND &gt; 0), min(($BackendMemoryStoreBoundCortexX925STALL_BACKEND_ST / $BackendMemoryStoreBoundCortexX925STALL_BACKEND_MEMBOUND), 1), 0)" name="Backend Memory Store Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Memory Cache Bound) (Cortex-X925)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the backend due to memory access latency issues caused by level 1 data cache misses" expression="if((($BackendCacheL1DBoundCortexX925STALL_BACKEND_L1D + $BackendCacheL1DBoundCortexX925STALL_BACKEND_MEM) &gt; 0), min(($BackendCacheL1DBoundCortexX925STALL_BACKEND_L1D / ($BackendCacheL1DBoundCortexX925STALL_BACKEND_L1D + $BackendCacheL1DBoundCortexX925STALL_BACKEND_MEM)), 1), 0)" name="Backend Cache L1D Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the backend due to memory access latency issues caused by level 2 data cache misses" expression="if((($BackendCacheL2DBoundCortexX925STALL_BACKEND_L1D + $BackendCacheL2DBoundCortexX925STALL_BACKEND_MEM) &gt; 0), min(($BackendCacheL2DBoundCortexX925STALL_BACKEND_MEM / ($BackendCacheL2DBoundCortexX925STALL_BACKEND_L1D + $BackendCacheL2DBoundCortexX925STALL_BACKEND_MEM)), 1), 0)" name="Backend Cache L2D Bound" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Data Cache Effectiveness (Backend Cache L1D Bound) (Cortex-X925)">
        <series color="255,153,0" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheMPKICortexX925INST_RETIRED &gt; 0), (($L1DCacheMPKICortexX925L1D_CACHE_REFILL / $L1DCacheMPKICortexX925INST_RETIRED) * 1000), 0)" name="L1D Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Data Cache Effectiveness (Backend Cache L1D Bound) (Cortex-X925)">
        <series color="255,153,0" description="This metric measures the ratio of level 1 data cache accesses missed to the total number of level 1 data cache accesses. This gives an indication of the effectiveness of the level 1 data cache." expression="if(($L1DCacheMissPercentageCortexX925L1D_CACHE &gt; 0), min(($L1DCacheMissPercentageCortexX925L1D_CACHE_REFILL / $L1DCacheMissPercentageCortexX925L1D_CACHE), 1), 0)" name="L1D Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Unified Cache Effectiveness (Backend Cache L2D Bound) (Cortex-X925)">
        <series color="255,153,0" description="This metric measures the number of level 2 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMPKICortexX925INST_RETIRED &gt; 0), (($L2CacheMPKICortexX925L2D_CACHE_REFILL / $L2CacheMPKICortexX925INST_RETIRED) * 1000), 0)" name="L2 Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2 Unified Cache Effectiveness (Backend Cache L2D Bound) (Cortex-X925)">
        <series color="255,153,0" description="This metric measures the ratio of level 2 cache accesses missed to the total number of level 2 cache accesses. This gives an indication of the effectiveness of the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMissPercentageCortexX925L2D_CACHE &gt; 0), min(($L2CacheMissPercentageCortexX925L2D_CACHE_REFILL / $L2CacheMissPercentageCortexX925L2D_CACHE), 1), 0)" name="L2 Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L3 Unified Cache Effectiveness (Backend Cache L2D Bound) (Cortex-X925)">
        <series color="255,153,0" description="This metric measures the number of level 3 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMPKICortexX925INST_RETIRED &gt; 0), (($L3CacheMPKICortexX925L3D_CACHE_REFILL / $L3CacheMPKICortexX925INST_RETIRED) * 1000), 0)" name="L3 Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L3 Unified Cache Effectiveness (Backend Cache L2D Bound) (Cortex-X925)">
        <series color="255,153,0" description="This metric measures the ratio of level 3 cache accesses missed to the total number of level 3 cache accesses. This gives an indication of the effectiveness of the level 3 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMissPercentageCortexX925L3D_CACHE &gt; 0), min(($L3CacheMissPercentageCortexX925L3D_CACHE_REFILL / $L3CacheMissPercentageCortexX925L3D_CACHE), 1), 0)" name="L3 Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Last Level Cache Effectiveness (Backend Cache L2D Bound) (Cortex-X925)">
        <series color="255,153,0" description="This metric measures the number of last level cache read accesses missed per thousand instructions executed" expression="if(($LLCacheReadMPKICortexX925INST_RETIRED &gt; 0), (($LLCacheReadMPKICortexX925LL_CACHE_MISS_RD / $LLCacheReadMPKICortexX925INST_RETIRED) * 1000), 0)" name="LL Cache Read MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Last Level Cache Effectiveness (Backend Cache L2D Bound) (Cortex-X925)">
        <series color="255,153,0" description="This metric measures the ratio of last level cache read accesses missed to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadMissPercentageCortexX925LL_CACHE_RD &gt; 0), min(($LLCacheReadMissPercentageCortexX925LL_CACHE_MISS_RD / $LLCacheReadMissPercentageCortexX925LL_CACHE_RD), 1), 0)" name="LL Cache Read Miss Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of last level cache read accesses hit in the cache to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadHitPercentageCortexX925LL_CACHE_RD &gt; 0), min((($LLCacheReadHitPercentageCortexX925LL_CACHE_RD - $LLCacheReadHitPercentageCortexX925LL_CACHE_MISS_RD) / $LLCacheReadHitPercentageCortexX925LL_CACHE_RD), 1), 0)" name="LL Cache Read Hit Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Data TLB Effectiveness (Backend Memory TLB Bound) (Cortex-X925)">
        <series color="255,153,0" description="This metric measures the number of data TLB Walks per thousand instructions executed" expression="if(($DTLBMPKICortexX925INST_RETIRED &gt; 0), (($DTLBMPKICortexX925DTLB_WALK / $DTLBMPKICortexX925INST_RETIRED) * 1000), 0)" name="DTLB MPKI" units="misses"/>
        <series color="153,0,255" description="This metric measures the number of level 1 data TLB accesses missed per thousand instructions executed" expression="if(($L1DataTLBMPKICortexX925INST_RETIRED &gt; 0), (($L1DataTLBMPKICortexX925L1D_TLB_REFILL / $L1DataTLBMPKICortexX925INST_RETIRED) * 1000), 0)" name="L1 Data TLB MPKI" units="misses"/>
        <series color="0,255,153" description="This metric measures the number of level 2 unified TLB accesses missed per thousand instructions executed" expression="if(($L2UnifiedTLBMPKICortexX925INST_RETIRED &gt; 0), (($L2UnifiedTLBMPKICortexX925L2D_TLB_REFILL / $L2UnifiedTLBMPKICortexX925INST_RETIRED) * 1000), 0)" name="L2 Unified TLB MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Data TLB Effectiveness (Backend Memory TLB Bound) (Cortex-X925)">
        <series color="255,153,0" description="This metric measures the ratio of data TLB Walks to the total number of data TLB accesses. This gives an indication of the effectiveness of the data TLB accesses." expression="if(($DTLBWalkPercentageCortexX925L1D_TLB &gt; 0), min(($DTLBWalkPercentageCortexX925DTLB_WALK / $DTLBWalkPercentageCortexX925L1D_TLB), 1), 0)" name="DTLB Walk Percentage" units="percent"/>
        <series color="255,0,153" description="This metric measures the ratio of data TLB Walks that returned large page to the total number of data TLB accesses" expression="if(($DTLBWalkLargePagePercentageCortexX925L1D_TLB &gt; 0), min(($DTLBWalkLargePagePercentageCortexX925DTLB_WALK_LARGE / $DTLBWalkLargePagePercentageCortexX925L1D_TLB), 1), 0)" name="DTLB Walk Large Page Percentage" units="percent"/>
        <series color="51,0,255" description="This metric measures the ratio of data TLB Walks that returned large page to the total number of data TLB accesses" expression="if(($DTLBWalkSmallPagePercentageCortexX925L1D_TLB &gt; 0), min(($DTLBWalkSmallPagePercentageCortexX925DTLB_WALK_SMALL / $DTLBWalkSmallPagePercentageCortexX925L1D_TLB), 1), 0)" name="DTLB Walk Small Page Percentage" units="percent"/>
        <series color="0,255,255" description="This metric measures the ratio of level 1 data TLB accesses missed to the total number of level 1 data TLB accesses. This gives an indication of the effectiveness of the level 1 data TLB." expression="if(($L1DataTLBMissPercentageCortexX925L1D_TLB &gt; 0), min(($L1DataTLBMissPercentageCortexX925L1D_TLB_REFILL / $L1DataTLBMissPercentageCortexX925L1D_TLB), 1), 0)" name="L1 Data TLB Miss Percentage" units="percent"/>
        <series color="51,255,0" description="This metric measures the ratio of level 2 unified TLB accesses missed to the total number of level 2 unified TLB accesses. This gives an indication of the effectiveness of the level 2 TLB." expression="if(($L2UnifiedTLBMissPercentageCortexX925L2D_TLB &gt; 0), min(($L2UnifiedTLBMissPercentageCortexX925L2D_TLB_REFILL / $L2UnifiedTLBMissPercentageCortexX925L2D_TLB), 1), 0)" name="L2 Unified TLB Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Data TLB Effectiveness (Backend Memory TLB Bound) (Cortex-X925)">
        <series color="255,153,0" description="This metric measures the average depth of the data TLB walks for a data TLB refill" expression="if(($DTLBWalkAverageDepthOfAccessesCortexX925DTLB_WALK &gt; 0), ($DTLBWalkAverageDepthOfAccessesCortexX925DTLB_STEP / $DTLBWalkAverageDepthOfAccessesCortexX925DTLB_WALK), 0)" name="DTLB Walk Average Depth of Accesses" units="accesses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Data TLB Effectiveness (Backend Memory TLB Bound) (Cortex-X925)">
        <series color="255,153,0" description="This metric measures the average latency of data TLB walks in CPU cycles" expression="if(($DTLBWalkAverageLatencyCortexX925DTLB_WALK &gt; 0), ($DTLBWalkAverageLatencyCortexX925DTLB_WALK_PERCYC / $DTLBWalkAverageLatencyCortexX925DTLB_WALK), 0)" name="DTLB Walk Average Latency" units="cycles"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Cortex-X925)">
        <series color="255,153,0" description="This metric measures instruction and data barrier operations as a percentage of operations speculatively executed" expression="if(($BarrierOperationsPercentageCortexX925INST_SPEC &gt; 0), min(((($BarrierOperationsPercentageCortexX925ISB_SPEC + $BarrierOperationsPercentageCortexX925DSB_SPEC) + $BarrierOperationsPercentageCortexX925DMB_SPEC) / $BarrierOperationsPercentageCortexX925INST_SPEC), 1), 0)" name="Barrier Operations Percentage" units="percent"/>
        <series color="255,0,102" description="This metric measures branch operations as a percentage of operations speculatively executed" expression="if(($BranchOperationsPercentageCortexX925INST_SPEC &gt; 0), min((($BranchOperationsPercentageCortexX925BR_IMMED_SPEC + $BranchOperationsPercentageCortexX925BR_INDIRECT_SPEC) / $BranchOperationsPercentageCortexX925INST_SPEC), 1), 0)" name="Branch Operations Percentage" units="percent"/>
        <series color="153,0,255" description="This metric measures crypto operations as a percentage of operations speculatively executed" expression="if(($CryptoOperationsPercentageCortexX925INST_SPEC &gt; 0), min(($CryptoOperationsPercentageCortexX925CRYPTO_SPEC / $CryptoOperationsPercentageCortexX925INST_SPEC), 1), 0)" name="Crypto Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures scalar integer operations as a percentage of operations speculatively executed" expression="if(($IntegerOperationsPercentageCortexX925INST_SPEC &gt; 0), min((($IntegerOperationsPercentageCortexX925DP_SPEC - $IntegerOperationsPercentageCortexX925DSB_SPEC) / $IntegerOperationsPercentageCortexX925INST_SPEC), 1), 0)" name="Integer Operations Percentage" units="percent"/>
        <series color="0,255,153" description="This metric measures load and store operations as a percentage of operations speculatively executed" expression="if(($LoadStoreOperationsPercentageCortexX925INST_SPEC &gt; 0), min(($LoadStoreOperationsPercentageCortexX925LDST_SPEC / $LoadStoreOperationsPercentageCortexX925INST_SPEC), 1), 0)" name="Load/Store Operations Percentage" units="percent"/>
        <series color="102,255,0" description="This metric measures scalar floating point operations as a percentage of operations speculatively executed" expression="if(($FloatingPointOperationsPercentageCortexX925INST_SPEC &gt; 0), min(($FloatingPointOperationsPercentageCortexX925VFP_SPEC / $FloatingPointOperationsPercentageCortexX925INST_SPEC), 1), 0)" name="Floating Point Operations Percentage" units="percent"/>
        <series color="128,77,0" description="This metric measures advanced SIMD operations as a percentage of total operations speculatively executed" expression="if(($AdvancedSIMDOperationsPercentageCortexX925INST_SPEC &gt; 0), min(($AdvancedSIMDOperationsPercentageCortexX925ASE_SPEC / $AdvancedSIMDOperationsPercentageCortexX925INST_SPEC), 1), 0)" name="Advanced SIMD Operations Percentage" units="percent"/>
        <series color="128,0,51" description="This metric measures scalable vector operations, including loads and stores, as a percentage of operations speculatively executed" expression="if(($SVEOperationsLoadStoreInclusivePercentageCortexX925INST_SPEC &gt; 0), min(($SVEOperationsLoadStoreInclusivePercentageCortexX925SVE_INST_SPEC / $SVEOperationsLoadStoreInclusivePercentageCortexX925INST_SPEC), 1), 0)" name="SVE Operations (Load/Store Inclusive) Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Cortex-X925)">
        <series color="255,153,0" description="This metric measures half-precision floating point operations as a percentage of operations speculatively executed" expression="if(($HalfPrecisionFloatingPointPercentageCortexX925INST_SPEC &gt; 0), min(($HalfPrecisionFloatingPointPercentageCortexX925FP_HP_SPEC / $HalfPrecisionFloatingPointPercentageCortexX925INST_SPEC), 1), 0)" name="Half Precision Floating Point Percentage" units="percent"/>
        <series color="153,0,255" description="This metric measures single-precision floating point operations as a percentage of operations speculatively executed" expression="if(($SinglePrecisionFloatingPointPercentageCortexX925INST_SPEC &gt; 0), min(($SinglePrecisionFloatingPointPercentageCortexX925FP_SP_SPEC / $SinglePrecisionFloatingPointPercentageCortexX925INST_SPEC), 1), 0)" name="Single Precision Floating Point Percentage" units="percent"/>
        <series color="0,255,153" description="This metric measures double-precision floating point operations as a percentage of operations speculatively executed" expression="if(($DoublePrecisionFloatingPointPercentageCortexX925INST_SPEC &gt; 0), min(($DoublePrecisionFloatingPointPercentageCortexX925FP_DP_SPEC / $DoublePrecisionFloatingPointPercentageCortexX925INST_SPEC), 1), 0)" name="Double Precision Floating Point Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Cortex-X925)">
        <series color="255,153,0" description="This metric measures load-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($LoadExclusiveInstructionsPercentageCortexX925INST_SPEC &gt; 0), min(($LoadExclusiveInstructionsPercentageCortexX925LDREX_SPEC / $LoadExclusiveInstructionsPercentageCortexX925INST_SPEC), 1), 0)" name="Load-Exclusive Instructions Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures store-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($StoreExclusiveInstructionsPercentageCortexX925INST_SPEC &gt; 0), min(($StoreExclusiveInstructionsPercentageCortexX925STREX_SPEC / $StoreExclusiveInstructionsPercentageCortexX925INST_SPEC), 1), 0)" name="Store-Exclusive Instructions Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Cortex-X925)">
        <series color="255,153,0" description="This metric measures load operations as a percentage of load and store operations speculatively executed" expression="if(($LoadAsLoadStoreOperationsPercentageCortexX925LDST_SPEC &gt; 0), min(($LoadAsLoadStoreOperationsPercentageCortexX925LD_SPEC / $LoadAsLoadStoreOperationsPercentageCortexX925LDST_SPEC), 1), 0)" name="Load as Load/Store Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures store operations as a percentage of load and store operations speculatively executed" expression="if(($StoreAsLoadStoreOperationsPercentageCortexX925LDST_SPEC &gt; 0), min(($StoreAsLoadStoreOperationsPercentageCortexX925ST_SPEC / $StoreAsLoadStoreOperationsPercentageCortexX925LDST_SPEC), 1), 0)" name="Store as Load/Store Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Cortex-X925)">
        <series color="255,153,0" description="This metric measures load operations as a percentage of operations speculatively executed" expression="if(($LoadOperationsPercentageCortexX925INST_SPEC &gt; 0), min(($LoadOperationsPercentageCortexX925LD_SPEC / $LoadOperationsPercentageCortexX925INST_SPEC), 1), 0)" name="Load Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures store operations as a percentage of operations speculatively executed" expression="if(($StoreOperationsPercentageCortexX925INST_SPEC &gt; 0), min(($StoreOperationsPercentageCortexX925ST_SPEC / $StoreOperationsPercentageCortexX925INST_SPEC), 1), 0)" name="Store Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Cortex-X925)">
        <series color="255,153,0" description="This metric measures memory-read instructions with acquire or acquirepc semantics as a percentage of instructions speculatively executed" expression="if(($LoadAcquireInstructionsPercentageCortexX925INST_SPEC &gt; 0), min(($LoadAcquireInstructionsPercentageCortexX925RC_LD_SPEC / $LoadAcquireInstructionsPercentageCortexX925INST_SPEC), 1), 0)" name="Load-Acquire Instructions Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures memory-write instructions with release semantics as a percentage of instructions speculatively executed" expression="if(($StoreReleaseInstructionsPercentageCortexX925INST_SPEC &gt; 0), min(($StoreReleaseInstructionsPercentageCortexX925RC_ST_SPEC / $StoreReleaseInstructionsPercentageCortexX925INST_SPEC), 1), 0)" name="Store-Release Instructions Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Branch Effectiveness (Bad Speculation) (Cortex-X925)">
        <series color="255,153,0" description="This metric measures the number of branch mispredictions per thousand instructions executed" expression="if(($BranchMPKICortexX925INST_RETIRED &gt; 0), (($BranchMPKICortexX925BR_MIS_PRED_RETIRED / $BranchMPKICortexX925INST_RETIRED) * 1000), 0)" name="Branch MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Effectiveness (Bad Speculation) (Cortex-X925)">
        <series color="255,153,0" description="This metric measures the ratio of branches mispredicted to the total number of branches architecturally executed. This gives an indication of the effectiveness of the branch prediction unit." expression="if(($BranchMispredictionPercentageCortexX925BR_RETIRED &gt; 0), min(($BranchMispredictionPercentageCortexX925BR_MIS_PRED_RETIRED / $BranchMispredictionPercentageCortexX925BR_RETIRED), 1), 0)" name="Branch Misprediction Percentage" units="percent"/>
        <series color="255,0,229" description="This metric measures the ratio of direct branches retired to the total number of branches architecturally executed" expression="if(($BranchDirectPercentageCortexX925BR_RETIRED &gt; 0), min(($BranchDirectPercentageCortexX925BR_IMMED_RETIRED / $BranchDirectPercentageCortexX925BR_RETIRED), 1), 0)" name="Branch Direct Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of indirect branches retired, including function returns, to the total number of branches architecturally executed" expression="if(($BranchIndirectPercentageCortexX925BR_RETIRED &gt; 0), min(($BranchIndirectPercentageCortexX925BR_IND_RETIRED / $BranchIndirectPercentageCortexX925BR_RETIRED), 1), 0)" name="Branch Indirect Percentage" units="percent"/>
        <series color="0,255,25" description="This metric measures the ratio of branches retired that are function returns to the total number of branches architecturally executed" expression="if(($BranchReturnPercentageCortexX925BR_RETIRED &gt; 0), min(($BranchReturnPercentageCortexX925BR_RETURN_RETIRED / $BranchReturnPercentageCortexX925BR_RETIRED), 1), 0)" name="Branch Return Percentage" units="percent"/>
   </chart>
    <select-metric id="ARMv9_Cortex_X925_metric_backend_bound" />
    <select-metric id="ARMv9_Cortex_X925_metric_backend_busy_bound" />
    <select-metric id="ARMv9_Cortex_X925_metric_backend_cache_l1d_bound" />
    <select-metric id="ARMv9_Cortex_X925_metric_backend_cache_l2d_bound" />
    <select-metric id="ARMv9_Cortex_X925_metric_backend_core_bound" />
    <select-metric id="ARMv9_Cortex_X925_metric_backend_core_rename_bound" />
    <select-metric id="ARMv9_Cortex_X925_metric_backend_mem_bound" />
    <select-metric id="ARMv9_Cortex_X925_metric_backend_mem_cache_bound" />
    <select-metric id="ARMv9_Cortex_X925_metric_backend_mem_store_bound" />
    <select-metric id="ARMv9_Cortex_X925_metric_backend_mem_tlb_bound" />
    <select-metric id="ARMv9_Cortex_X925_metric_backend_stalled_cycles" />
    <select-metric id="ARMv9_Cortex_X925_metric_bad_speculation" />
    <select-metric id="ARMv9_Cortex_X925_metric_barrier_percentage" />
    <select-metric id="ARMv9_Cortex_X925_metric_branch_direct_ratio" />
    <select-metric id="ARMv9_Cortex_X925_metric_branch_indirect_ratio" />
    <select-metric id="ARMv9_Cortex_X925_metric_branch_misprediction_ratio" />
    <select-metric id="ARMv9_Cortex_X925_metric_branch_mpki" />
    <select-metric id="ARMv9_Cortex_X925_metric_branch_percentage" />
    <select-metric id="ARMv9_Cortex_X925_metric_branch_return_ratio" />
    <select-metric id="ARMv9_Cortex_X925_metric_crypto_percentage" />
    <select-metric id="ARMv9_Cortex_X925_metric_dtlb_mpki" />
    <select-metric id="ARMv9_Cortex_X925_metric_dtlb_walk_average_depth" />
    <select-metric id="ARMv9_Cortex_X925_metric_dtlb_walk_average_latency" />
    <select-metric id="ARMv9_Cortex_X925_metric_dtlb_walk_large_ratio" />
    <select-metric id="ARMv9_Cortex_X925_metric_dtlb_walk_ratio" />
    <select-metric id="ARMv9_Cortex_X925_metric_dtlb_walk_small_ratio" />
    <select-metric id="ARMv9_Cortex_X925_metric_fp16_percentage" />
    <select-metric id="ARMv9_Cortex_X925_metric_fp32_percentage" />
    <select-metric id="ARMv9_Cortex_X925_metric_fp64_percentage" />
    <select-metric id="ARMv9_Cortex_X925_metric_frontend_bound" />
    <select-metric id="ARMv9_Cortex_X925_metric_frontend_cache_l1i_bound" />
    <select-metric id="ARMv9_Cortex_X925_metric_frontend_cache_l2i_bound" />
    <select-metric id="ARMv9_Cortex_X925_metric_frontend_core_bound" />
    <select-metric id="ARMv9_Cortex_X925_metric_frontend_core_flow_bound" />
    <select-metric id="ARMv9_Cortex_X925_metric_frontend_core_flush_bound" />
    <select-metric id="ARMv9_Cortex_X925_metric_frontend_mem_bound" />
    <select-metric id="ARMv9_Cortex_X925_metric_frontend_mem_cache_bound" />
    <select-metric id="ARMv9_Cortex_X925_metric_frontend_mem_tlb_bound" />
    <select-metric id="ARMv9_Cortex_X925_metric_frontend_stalled_cycles" />
    <select-metric id="ARMv9_Cortex_X925_metric_integer_dp_percentage" />
    <select-metric id="ARMv9_Cortex_X925_metric_ipc" />
    <select-metric id="ARMv9_Cortex_X925_metric_itlb_mpki" />
    <select-metric id="ARMv9_Cortex_X925_metric_itlb_walk_average_depth" />
    <select-metric id="ARMv9_Cortex_X925_metric_itlb_walk_average_latency" />
    <select-metric id="ARMv9_Cortex_X925_metric_itlb_walk_large_ratio" />
    <select-metric id="ARMv9_Cortex_X925_metric_itlb_walk_ratio" />
    <select-metric id="ARMv9_Cortex_X925_metric_itlb_walk_small_ratio" />
    <select-metric id="ARMv9_Cortex_X925_metric_l1d_cache_miss_ratio" />
    <select-metric id="ARMv9_Cortex_X925_metric_l1d_cache_mpki" />
    <select-metric id="ARMv9_Cortex_X925_metric_l1d_tlb_miss_ratio" />
    <select-metric id="ARMv9_Cortex_X925_metric_l1d_tlb_mpki" />
    <select-metric id="ARMv9_Cortex_X925_metric_l1i_cache_miss_ratio" />
    <select-metric id="ARMv9_Cortex_X925_metric_l1i_cache_mpki" />
    <select-metric id="ARMv9_Cortex_X925_metric_l1i_tlb_miss_ratio" />
    <select-metric id="ARMv9_Cortex_X925_metric_l1i_tlb_mpki" />
    <select-metric id="ARMv9_Cortex_X925_metric_l2_cache_miss_ratio" />
    <select-metric id="ARMv9_Cortex_X925_metric_l2_cache_mpki" />
    <select-metric id="ARMv9_Cortex_X925_metric_l2_tlb_miss_ratio" />
    <select-metric id="ARMv9_Cortex_X925_metric_l2_tlb_mpki" />
    <select-metric id="ARMv9_Cortex_X925_metric_l3_cache_miss_ratio" />
    <select-metric id="ARMv9_Cortex_X925_metric_l3_cache_mpki" />
    <select-metric id="ARMv9_Cortex_X925_metric_ldrex_percentage" />
    <select-metric id="ARMv9_Cortex_X925_metric_ll_cache_read_hit_ratio" />
    <select-metric id="ARMv9_Cortex_X925_metric_ll_cache_read_miss_ratio" />
    <select-metric id="ARMv9_Cortex_X925_metric_ll_cache_read_mpki" />
    <select-metric id="ARMv9_Cortex_X925_metric_load_ls_percentage" />
    <select-metric id="ARMv9_Cortex_X925_metric_load_percentage" />
    <select-metric id="ARMv9_Cortex_X925_metric_load_store_percentage" />
    <select-metric id="ARMv9_Cortex_X925_metric_rc_ld_percentage" />
    <select-metric id="ARMv9_Cortex_X925_metric_rc_st_percentage" />
    <select-metric id="ARMv9_Cortex_X925_metric_retired_ops_percent" />
    <select-metric id="ARMv9_Cortex_X925_metric_retiring" />
    <select-metric id="ARMv9_Cortex_X925_metric_scalar_fp_percentage" />
    <select-metric id="ARMv9_Cortex_X925_metric_simd_percentage" />
    <select-metric id="ARMv9_Cortex_X925_metric_store_ls_percentage" />
    <select-metric id="ARMv9_Cortex_X925_metric_store_percentage" />
    <select-metric id="ARMv9_Cortex_X925_metric_strex_percentage" />
    <select-metric id="ARMv9_Cortex_X925_metric_sve_all_percentage" />
</template>
